/*------------------------------------------------------------------------------*
 * File Name:ApplyFormats.c	 													*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Apply Formats Dialog						*
 * Copyright (c) Originlab Corp.	2002										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 * 	Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS						*
 *	CPY 12/19/06 QA70-12736 RESTORE_THEME_OC_FUNC_FOR_LT_DIRECT_CALL			*
 *------------------------------------------------------------------------------*/
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include <TreeEditor.h>
//#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids /// /// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include <Selection.h>
//#include "theme_utils.h" /// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

static Dialog MyDlg("ApplyFormats", "ODlg");


static	string s_strThemeFilename;
static	string	s_strTempThemeFilename;

static	void	FilteredFileCleanup()
{
	if (s_strTempThemeFilename.IsFile())
		DeleteFile(s_strTempThemeFilename);
	
	s_strTempThemeFilename = "";
}

// need to place theme file into local static s_strThemeFilename
static bool prepare_theme_for_Dialog(LPCSTR lpcszThemeFile = NULL) // NULL means from clibpoard
{
	ASSERT(s_strThemeFilename.IsEmpty());
	
	if(lpcszThemeFile)
		s_strThemeFilename = lpcszThemeFile;
	else
	{
		if(!theme_is_in_clipboard())
			return false;
		
		if(!GetTempFileName(s_strThemeFilename))
			return false;
		
		if(!CopyThemeFromClipboard(s_strThemeFilename))
		{
			DeleteFile(s_strThemeFilename);
			return false;
		}
	}
	
	if(!GetTempFileName(s_strTempThemeFilename))
		return false;
	
	if(s_strThemeFilename.IsFile())
		return true;
	
	return false;
}

static bool is_wks_active()
{
	Page pg = Project.Pages();
	return pg && pg.GetType() == EXIST_WKS;
}

static int	get_apply_to()
{
	int nApplyTo = THEMEAPPLY_PAGE;
	
	if( Selection.Objects.Count() > 0 )
		nApplyTo = THEMEAPPLY_SELECTION;
	else if( is_wks_active() )
		nApplyTo = THEMEAPPLY_LAYER;
	
	return nApplyTo;
}


// from LabTalk, this will create Modeless dialog	
bool StartApplyFormatsDialog(string strThemeFilename = "")
{
	if(strThemeFilename.IsEmpty())
		prepare_theme_for_Dialog(NULL);
	else
		prepare_theme_for_Dialog(strThemeFilename);
	
	return MyDlg.Create();
}

BEGIN_EVENT_MAP
	ON_INIT(OnInitDialog) 
	ON_BN_CLICKED(IDC_APPLYSTYLE_DOIT, OnApply)
	ON_BN_CLICKED(IDC_APPLYSTYLE_SELECTED, OnApplySelected)
	ON_BN_CLICKED(IDC_APPLYSTYLE_LIST_VIEW, OnCheck)
	ON_BN_CLICKED(IDC_APPLYSTYLE_COLLECTIONS, OnCheck)
	ON_CBN_SELCHANGE(IDC_APPLYSTYLE_TREE, OnTreeSelChange)
	ON_DESTROY(OnDestroy)
END_EVENT_MAP

static BOOL OnCheck(Control oCntrl)
{
	///Frank 9/13/05 REMOVE_DIALOGEX_FROM_THEME_ULTILS
	///Because remove the dialogex.h, so the dialog relate operator will move out....
	//theme_update_tree_list_view(MyDlg, IDC_APPLYSTYLE_LIST_VIEW, IDC_APPLYSTYLE_TREE);
	//return true;
	return update_tree_list_view_af();
	///End REMOVE_DIALOGEX_FROM_THEME_ULTILS
}
///Frank 9/13/05 REMOVE_DIALOGEX_FROM_THEME_ULTILS
static bool update_tree_list_view_af()
{
	Button btnListView = MyDlg.GetItem(IDC_APPLYSTYLE_LIST_VIEW);
	bool bListViewCheck  = btnListView.Check;
	
	Button btnCollections = MyDlg.GetItem(IDC_APPLYSTYLE_COLLECTIONS);
	bool bCollectionsCheck  = btnCollections.Check;
	btnCollections.Enable = !bListViewCheck;

	DWORD dwSetting = theme_update_tree_list_view(bListViewCheck, bCollectionsCheck);
	TreeEditor tree = MyDlg.GetItem(IDC_APPLYSTYLE_TREE);
	
	tree.View = dwSetting;
	
	return TRUE;
	
}
///End REMOVE_DIALOGEX_FROM_THEME_ULTILS

///////////////////////////////////////////////////////
/// Initialization
///////////////////////////////////////////////////////
static BOOL OnInitDialog()
{
	ComboBox comboApplyTo = MyDlg.GetItem(IDC_APPLYSTYLE_TO);
	
	if( is_wks_active() )
	{
		comboApplyTo.ResetContent();
		if( Selection.Objects.Count() > 0 )
			comboApplyTo.AddString(_L("Selection")); 
		comboApplyTo.AddString(_L("Active Sheet")); 
		comboApplyTo.AddString(_L("All Sheets in this Book"));
		comboApplyTo.AddString(_L("All Sheets in this Folder"));
		comboApplyTo.AddString(_L("All Sheets in this Project"));
	}
	else
	{
		comboApplyTo.ResetContent();
		if( Selection.Objects.Count() > 0 )
			comboApplyTo.AddString(_L("Selection"));
		comboApplyTo.AddString(_L("Active Graph")); 
		comboApplyTo.AddString(_L("All Graphs in this Folder"));
		comboApplyTo.AddString(_L("All Graphs in this Project"));
	}
	
	int nSel = get_apply_to();
	
	comboApplyTo.SetCurSel(nSel);

	MyDlg.Tree.SetRef(2); // 0 = to disable controls movement, 1 for page dialog, 2 for simple dialog
	
	TreeEditor tree 	= MyDlg.GetItem(IDC_APPLYSTYLE_TREE);
	tree.Load(s_strThemeFilename);
	//theme_update_tree_list_view(MyDlg, IDC_APPLYSTYLE_LIST_VIEW, IDC_APPLYSTYLE_TREE);
	update_tree_list_view_af();

	MyDlg.GetItem(IDC_APPLYSTYLE_SELECTED).Enable = false;
	return true;
}

///////////////////////////////////////////////////////
//// Cleanup
///////////////////////////////////////////////////////
static BOOL OnDestroy(void)
{
	FilteredFileCleanup();
	
	if(s_strThemeFilename.IsFile())
		DeleteFile(s_strThemeFilename);

	s_strThemeFilename.Empty();
	
	return TRUE;
}

//nApplyTo = -1 if called from inside dialog, if nApplyTo is not -1, then we
//are using this outside dialog so there should be no call to MyDlg to GetDlgItem 
static bool apply_formats(bool bSelected = false, int nApplyTo = -1)
{
	string		strApplyFile = s_strThemeFilename;
	
	if( nApplyTo < 0 )
	{
		TreeEditor tree = MyDlg.GetItem(IDC_APPLYSTYLE_TREE);
		
		if( !tree.Save(s_strTempThemeFilename, bSelected, TRUE) )
			return false;
		
		strApplyFile = s_strTempThemeFilename;
		
		ComboBox comboApplyTo = MyDlg.GetItem(IDC_APPLYSTYLE_TO);
		nApplyTo = get_apply_to() + comboApplyTo.GetCurSel();
	}

	return theme_apply(nApplyTo, strApplyFile);
}

static BOOL OnApply(Control oCntrl)
{
	return apply_formats();
}

static BOOL OnApplySelected(Control oCntrl)
{
	return apply_formats(true);
}

/// notification from OTreeEditor grid changes
static BOOL OnTreeSelChange(Control oCntrl)
{
	TreeEditor tree = oCntrl;
	int nCount = tree.GetSelectedRows(NULL, TRUE);
	//out_int("Num leafs selected=", nCount);
	Button btnApplySelected = MyDlg.GetItem(IDC_APPLYSTYLE_SELECTED);
	btnApplySelected.Enable = nCount>0? TRUE:FALSE;
	return FALSE; // no need for further processing
}

///////////////////////////////////////////////////////////////////////////////////
//---- CPY 12/19/06 QA70-12736 RESTORE_THEME_OC_FUNC_FOR_LT_DIRECT_CALL
//#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS
#pragma labtalk(1, Theme)
//----

// from LabTalk, use DoModal
//nOpenDlg
// 1=Shift,Must Open
// 0=From Context menu, no shift key, check IsShiftShow
// 2=From Edit, MustOpen
bool PasteFormatsDialog(int nOpenDlg) 
{
	prepare_theme_for_Dialog();
	
	if(nOpenDlg > 0) //CPY 1/17/03, no ShiftShow check box, always assume checked
	{
		MyDlg.DoModal();
	}
	else
	{
		int nApplyTo = get_apply_to();
		apply_formats(false, nApplyTo);
	}
	
	return true;
}


